% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step2factors.R
\name{step2factors}
\alias{step2factors}
\title{Performs Factor Analysis to Select a Subset of the 24 Measures}
\usage{
step2factors(
  trajMeasures,
  num.factors = NULL,
  discard = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{trajMeasures}{List generated by \code{step1mesures}. Contains
original data, original time and 24 measures.}

\item{num.factors}{Numerical value specifying the number
of factors to choose. Defaults to \code{NULL}.
See details.Defaults to \code{NULL}.}

\item{discard}{Vector containing names or numerical
positions of measures to discard during factor analysis.}

\item{verbose}{Logical indicating if the function should
print information on screen. Defaults to \code{TRUE}.}

\item{\dots}{Arguments to be passed to \code{principal}. See details.}
}
\value{
trajFactors Object containing the measures chosen as factors, the eigenvalues of the correlation matrix of the 24 measures, the list generated by the
\code{principal} function used for the factor analysis and the data stored in the \code{trajMeasures} object.
}
\description{
Performs a factor analysis to reduce the set of 24 measures into a smaller set of measures that captures the main features of the trajectories.
}
\details{
If \code{num.factor} is \code{NULL},the function will select the number of factors as the number of eigenvalues greater than 1.

The \code{\link[psych]{principal}} function is used in order to choose the measure that will represent each factor. \code{varimax} is used to rotate the data during
the execution of the\ code{principal} function. Any other parameter can be passed through \code{\dots} in order to further control the \code{principal} function.

If any measures that happen to be extremely correlated among themselves (corr. >= 0.95), one of them
will have to be removed. Such measures are flagged by \code{step1measures}. These values can be removed with \code{discard} or they will be automatically removed by the function.
}
\examples{
\dontrun{
# Setup data 
data = example.data$data

# Run step1measures and step2factors
s1 = step1measures(data, ID=TRUE)
s2 = step2factors(s1)

# Display factors
head(s2$factors)

# The next step would be to run "step3clusters"
}


}
\seealso{
\code{\link[psych]{principal}}
\code{\link[traj]{step1measures}}
}
\author{
Marie-Pierre Sylvestre, Dan Vatnik

marie-pierre.sylvestre@umontreal.ca
}
