% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step3Clusters.R
\name{Step3Clusters}
\alias{Step3Clusters}
\alias{print.trajClusters}
\alias{summary.trajClusters}
\title{Classify the Longitudinal Data Based on the Selected Measures.}
\usage{
Step3Clusters(
  trajSelection,
  nclusters = NULL,
  nstart = 50,
  iter.max = 20,
  K.max = 8,
  B = 500,
  d.power = 2,
  spaceH0 = "scaledPCA",
  method = "Tibs2001SEmax",
  SE.factor = 1
)

\method{print}{trajClusters}(x, ...)

\method{summary}{trajClusters}(object, ...)
}
\arguments{
\item{trajSelection}{object of class \code{trajSelection} as returned by
\code{Step2Selection}.}

\item{nclusters}{either NULL or the desired number of clusters. If NULL, the
number of clustersis determined using the GAP criterion as implemented in
the \code{\link[cluster]{clusGap}} function.}

\item{nstart}{to be passed to the \code{nstart} argument of
\code{\link[stats]{kmeans}}.}

\item{iter.max}{to be passed to the \code{iter.max} argument of
\code{\link[stats]{kmeans}}.}

\item{K.max}{to be passed to the \code{K.max} argument of
\code{\link[cluster]{clusGap}}.}

\item{B}{to be passed to the \code{SE.factor} argument of
\code{\link[cluster]{clusGap}}.}

\item{d.power}{to be passed to the \code{B} argument of
\code{\link[cluster]{clusGap}}.}

\item{spaceH0}{to be passed to the \code{spaceH0} argument of
\code{\link[cluster]{clusGap}}.}

\item{method}{to be passed to the \code{method} argument of
\code{\link[cluster]{clusGap}}.}

\item{SE.factor}{to be passed to the \code{SE.factor} argument of
\code{\link[cluster]{clusGap}}.}

\item{x}{object of class trajClusters}

\item{...}{further arguments passed to or from other methods.}

\item{object}{object of class trajClusters}
}
\value{
An object of class \code{trajClusters}; a list containing the result
of the clustering, the output of the \code{clusGap} function, as well as a
curated form of the arguments.
}
\description{
Classifies the trajectories by applying the K-mean clustering
algorithm to the measures selected by \code{Step2Selection}.
}
\examples{
\dontrun{

m = Step1Measures(trajdata, ID = TRUE)
s = Step2Selection(m)

s$RC$loadings

s2 = Step2Selection(m, select = c(10, 12, 8, 4))

c3.part <- Step3Clusters(s2, nclusters = 3)$partition
c4.part <- Step3Clusters(s2, nclusters = 4)$partition
c5.part <- Step3Clusters(s2, nclusters = 5)$partition

}

}
\seealso{
\code{\link[traj]{Step2Selection}}
}
