% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3D.R
\name{Traj3DResampleTime}
\alias{Traj3DResampleTime}
\title{Resample a 3D trajectory to a constant time interval}
\usage{
Traj3DResampleTime(trj3d, stepTime, newFps = NULL)
}
\arguments{
\item{trj3d}{The 3-dimensional trajectory to be resampled.}

\item{stepTime}{The resampled trajectory step time. Each step in the new
trajectory will have this duration.}

\item{newFps}{Value to be stored as the FPS value in the new trajectory (see
\code{\link{TrajGetFPS}}). It is not otherwise used by this function.}
}
\value{
A new 3-dimensional trajectory with a constant time interval for each
  step. Points in the new trajectory are calculated by linearly interpolating
  along \code{trj3d}.
}
\description{
Constructs a new 3-dimensional trajectory by resampling the input trajectory
to a fixed time interval. Points are linearly interpolated along the
trajectory. Spatial and time units are preserved.
}
\seealso{
\code{\link{Traj3DFromCoords}}, \code{\link{TrajResampleTime}}
}
