% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcov.LmME}
\alias{vcov.LmME}
\title{Get the variance-covariance matrix of the parameters of an LmME model}
\usage{
\method{vcov}{LmME}(
  object,
  as.lm = FALSE,
  parm = NULL,
  pargroup = c("all", "fixef", "shift", "baseline", "ranef"),
  pmatch = FALSE,
  ...
)
}
\arguments{
\item{object}{A fitted LmME object.}

\item{as.lm}{If TRUE, return the covariance matrix of the transformed
parameters as in a \code{lmerMod} object.}

\item{parm}{The indeces or names of the parameters of interest. See in details.}

\item{pargroup}{fixef: fixed-effects, shift: shift parameters, all: fixed
effects and variance component parameters, baseline: parameters of the
baseline transformation function, ranef: variance components parameters.}

\item{pmatch}{Logical. If \code{TRUE}, partial name matching is allowed.}

\item{...}{Optional arguments}
}
\value{
A numeric covariance matrix.
}
\description{
\code{pargroup = "baseline"} is not available for \code{LmME} objects.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
vcov(fit) ## transformation model parametrization
vcov(fit, as.lm = TRUE) ## LMM parametrization
## cov of coefficient AND other terms with 'Days' in names
vcov(fit, as.lm = TRUE, parm = "Days", pmatch = TRUE)
vcov(fit, as.lm = TRUE, parm = "^Days", pmatch = TRUE) ## var of coefficient only
vcov(fit, as.lm = TRUE, pargroup = "fixef") ## cov of fixed effects
}
