% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{VarCorr.tramME}
\alias{VarCorr.tramME}
\alias{VarCorr}
\title{Variances and correlation matrices of random effects}
\usage{
\method{VarCorr}{tramME}(x, ...)
}
\arguments{
\item{x}{A \code{tramME} object}

\item{...}{optional arguments (for consistency with the generic method)}
}
\value{
A list of vectors with variances and correlation matrices corresponding to the
  various grouping variables.
}
\description{
This function calculates the variances and correlations from \code{varcov.tramME}.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- BoxCoxME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
VarCorr(fit)
}
