% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LmME.R
\name{varcov.LmME}
\alias{varcov.LmME}
\title{Extract the variance-covariance matrix of the random effects of an LmME model}
\usage{
\method{varcov}{LmME}(object, as.lm = FALSE, as.theta = FALSE, full = FALSE, ...)
}
\arguments{
\item{object}{A \code{LmME} object.}

\item{as.lm}{If \code{TRUE}, the returned values correspond to the LMM
parametrization.}

\item{as.theta}{Logical value, if \code{TRUE}, the values are returned
in their reparameterized form.}

\item{full}{Logical value; if \code{TRUE}, return all random effects elements,
if \code{FALSE}, do not return the random effects parameters of the smooth
terms.}

\item{...}{Optional arguments (unused).}
}
\value{
A list of the covariance matrices or a vector of theta values.
}
\description{
Extract the variance-covariance matrix of the random effects of an LmME model
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
varcov(fit, as.lm = TRUE)
varcov(fit, as.theta = TRUE, as.lm = TRUE)
}
