% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssFrame.R
\name{xpssFrame}
\alias{xpssFrame}
\title{Creates a xpssFrame Object}
\usage{
xpssFrame(x, ...)
}
\arguments{
\item{x}{as character string with the name of the file.}

\item{\dots}{Arguments to pass on read.spss() from foreign.}
}
\description{
xpssFrame creates a dataset as an xpssFrame object from a local file.
}
\details{
\code{x} the input data should be of the format \emph{.sav}.

The SPSS dataset contains the following attributes: \code{names}, \code{codepage}, \code{row.names}, \code{FILTER}, \code{TEMPORAY}, \code{SPLIT_FILE}, \code{DO_IF}, \code{SELECT_IF}, \code{WEIGHTS}, \code{class}

\tabular{rlll}{
 \tab Attribute \tab Type \tab Contain \cr
\tab \code{names} \tab atomic character or character vector \tab Name of the variable in the dataset \cr
\tab \code{codepage} \tab atomic numeric \tab ANSI code, which describe the encoding \cr
\tab \code{row.names}  \tab atomic numeric or numeric vector \tab row ID's  \cr
\tab \code{FILTER} \tab atomic logical or condition \tab Filtercondition or FALSE if \code{\link{xpssFilter}} is off\cr
\tab \code{TEMPORARY} \tab atomic logical \tab Logical statement if \code{\link{xpssTemporary}} is on or off \cr
\tab \code{SPLIT_FILE} \tab atomic logical \tab Split-File condition or FALSE if \code{\link{xpssSplitFile}} is off \cr
\tab \code{DO_IF} \tab atomic logical or condition \tab Do-If-condition or FALSE if \code{\link{xpssDoIf}} is off \cr
\tab \code{SELECT_IF} \tab atomic logical or condition \tab Select-If-condition or FALSE if \code{\link{xpssSelectIf}} is off \cr
\tab \code{WEIGHTS} \tab atomic character \tab  * will be implemented in a following update \cr
\tab \code{class} \tab atomic character or character \tab atomic or vector of names of classes the datasets inherits from.  \cr
}

Variable attributes are stored in the variable itself. A variable can have the following attributes:
\code{defined.MIS}, \code{MIS}, \code{value.labels}, \code{variable.label}, \code{varname}
 \tabular{rlll}{
 \tab Attribute \tab Type \tab Contain \cr
\tab \code{defined.MIS} \tab Atomic numerics or atomic characters, respectively a numeric vector or character vector \tab Values which specify missing values \cr
\tab \code{MIS} \tab list with user-defined missings \tab POS contain the position of the user-defined missing, VAL the value of the user defined-missing \cr
\tab \code{value.labels}  \tab Named numeric or named character \tab  Value and label for a specific variable\cr
\tab \code{variable.label} \tab Atomic character \tab Label of the variable\cr
\tab \code{varname} \tab Atomic character \tab Name of the variable in the datasheet\cr
}
}
\examples{
\dontrun{
data <- xpssFrame(x="Testdata_1.sav")
}
}
\author{
Andreas Wygrabek
}
\seealso{
\code{\link{read.spss}} \code{\link{as.xpssFrame}}
}

