% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-translator.R
\name{translator}
\alias{translator}
\alias{is_translator}
\alias{format.Translator}
\alias{print.Translator}
\alias{Translator}
\title{Source Texts and Translations}
\usage{
translator(..., id = uuid(), algorithm = constant("algorithms"))

is_translator(x)

\method{format}{Translator}(x, ...)

\method{print}{Translator}(x, ...)
}
\arguments{
\item{...}{Usage depends on the underlying function.
\itemize{
\item Any number of \code{\link{Text}} objects and/or named character
strings for \code{\link[=translator]{translator()}} (in no preferred order).
\item Further arguments passed to or from other methods for \code{\link[=format]{format()}},
and \code{\link[=print]{print()}}.
}}

\item{id}{A non-empty and non-\link[base:NA]{NA} character string. A globally
unique identifier for the \code{\link{Translator}} object. Beware of
plausible collisions when using user-defined values.}

\item{algorithm}{A non-empty and non-\link[base:NA]{NA} character string
equal to \code{"sha1"}, or \code{"utf8"}. The algorithm to use when hashing
source information for identification purposes.}

\item{x}{Any \R object.}
}
\value{
\code{\link[=translator]{translator()}} returns an \code{\link[R6:R6Class]{R6}} object of class
\code{\link{Translator}}.

\code{\link[=is_translator]{is_translator()}} returns a logical value.

\code{\link[=format]{format()}} returns a character vector.

\code{\link[=print]{print()}} returns argument \code{x} invisibly.
}
\description{
Structure and manipulate the source text of a project and its translations.
}
\details{
A \code{\link{Translator}} object encapsulates the source text of a
project (or any other \emph{context}) and all related translations. It exposes
a set of methods that can be used to manipulate this information, but it
is designed in such a way that its methods can be ignored most of the time.

Under the hood, \code{\link{Translator}} objects are collections of
\code{\link{Text}} objects. These do most of the work. They are treated as
lower-level component and in typical situations, users rarely interact
with them.
\subsection{Translating Text}{

Since it can be detected and processed by \code{\link[=find_source]{find_source()}}, it is recommended
to use \code{\link[=translate]{translate()}} at all times. Method
\code{\link[=Translator]{Translator$translate()}} is the underlying workhorse function
called by the former.
}

\subsection{Exporting and Importing Translators}{

\code{\link{Translator}} objects can be saved and exported with
\code{\link[=translator_write]{translator_write()}}.

They can be imported back into an \R session with \code{\link[=translator_read]{translator_read()}}.
}
}
\examples{
# Set source language.
language_source_set("en")

# Create a Translator object.
# This would normally be done automatically
# by find_source(), or translator_read().
tr <- translator(
  id = "test-translator",
  en = "English",
  es = "Español",
  fr = "Français",
  text(
    location("a", 1L, 2L, 3L, 4L),
    en = "Hello, world!",
    fr = "Bonjour, monde!"),
  text(
    location("b", 1L, 2L, 3L, 4L),
    en = "Farewell, world!",
    fr = "Au revoir, monde!"))

is_translator(tr)

# Translator objects has a specific format.
# print() calls format() internally, as expected.
print(tr)


## ------------------------------------------------
## Method `Translator$new`
## ------------------------------------------------

# Consider using translator() instead.
tr <- Translator$new()

## ------------------------------------------------
## Method `Translator$translate`
## ------------------------------------------------

tr <- Translator$new()
tr$set_text(en = "Hello, world!", fr = "Bonjour, monde!")

# Consider using translate() instead.
tr$translate("Hello, world!", lang = "en")  ## Outputs "Hello, world!"
tr$translate("Hello, world!", lang = "fr")  ## Outputs "Bonjour, monde!"

## ------------------------------------------------
## Method `Translator$get_translation`
## ------------------------------------------------

tr <- Translator$new()
tr$set_text(en = "Hello, world!")

# Consider using translate() instead.
tr$get_translation("256e0d7", "en")  ## Outputs "Hello, world!"

## ------------------------------------------------
## Method `Translator$get_text`
## ------------------------------------------------

tr <- Translator$new()
tr$set_text(en = "Hello, world!")

tr$get_translation("256e0d7", "en")  ## Outputs "Hello, world!"

## ------------------------------------------------
## Method `Translator$set_text`
## ------------------------------------------------

tr <- Translator$new()

tr$set_text(en = "Hello, world!", location())

## ------------------------------------------------
## Method `Translator$set_texts`
## ------------------------------------------------

# Set source language.
language_source_set("en")

tr <- Translator$new()

# Create Text objects.
txt1 <- text(
  location("a", 1L, 2L, 3L, 4L),
  en = "Hello, world!",
  fr = "Bonjour, monde!")

txt2 <- text(
  location("b", 5L, 6L, 7L, 8L),
  en = "Farewell, world!",
  fr = "Au revoir, monde!")

tr$set_texts(txt1, txt2)

## ------------------------------------------------
## Method `Translator$set_native_languages`
## ------------------------------------------------

tr <- Translator$new()

tr$set_native_languages(en = "English", fr = "Français")

# Remove existing entries.
tr$set_native_languages(fr = NULL)

## ------------------------------------------------
## Method `Translator$rm_text`
## ------------------------------------------------

tr <- Translator$new()
tr$set_text(en = "Hello, world!")

tr$rm_text("256e0d7")
}
\seealso{
\code{\link[=translate]{translate()}},
\code{\link[=translator_read]{translator_read()}},
\code{\link[=translator_write]{translator_write()}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{id}}{A non-empty and non-\link[base:NA]{NA} character string. A globally
unique identifier for the underlying object. Beware of plausible
collisions when using user-defined values.}

\item{\code{algorithm}}{A non-empty and non-\link[base:NA]{NA} character string
equal to \code{"sha1"}, or \code{"utf8"}. The algorithm to use when hashing
source information for identification purposes.}

\item{\code{hashes}}{A character vector of non-empty and non-\link[base:NA]{NA}
values, or \code{NULL}. The set of all \code{hash} exposed by registered
\code{\link{Text}} objects. If there is none, \code{hashes} is \code{NULL}.
This is a \strong{read-only} field. It is automatically updated
whenever field \code{algorithm} is updated.}

\item{\code{source_texts}}{A character vector of non-empty and
non-\link[base:NA]{NA} values, or \code{NULL}. The set of all
\code{source_text} exposed by registered \code{\link{Text}}
objects. If there is none, \code{source_texts} is \code{NULL}.
This is a \strong{read-only} field.}

\item{\code{source_langs}}{A character vector of non-empty and
non-\link[base:NA]{NA} values, or \code{NULL}. The set of all
\code{source_text} exposed by registered \code{\link{Text}}
objects. This is a \strong{read-only} field.
\itemize{
\item If there is none, \code{source_texts} is \code{NULL}.
\item If there is one unique value, \code{source_texts} has
a length equal to 1.
\item Otherwise, a named character vector is returned.
}}

\item{\code{languages}}{A character vector of non-empty and
non-\link[base:NA]{NA} values, or \code{NULL}. The set of all
\code{languages} (codes) exposed by registered \code{\link{Text}}
objects. If there is none, \code{languages} is \code{NULL}.
This is a \strong{read-only} field.}

\item{\code{native_languages}}{A named character vector of non-empty and
non-\link[base:NA]{NA} values, or \code{NULL}. A map (bijection) of
\code{languages} (codes) to native language names. Names are codes,
and values are native languages. If there is none,
\code{native_languages} is \code{NULL}.

While users retain full control over \code{native_languages}, it is
best to use well-known schemes such as
\href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47}, or
\href{https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes}{ISO 639-1}.
Doing so maximizes portability and cross-compatibility between packages.

Update this field with method
\code{\link[=Translator]{Translator$set_native_languages()}}. See below for
more information.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Translator-new}{\code{Translator$new()}}
\item \href{#method-Translator-translate}{\code{Translator$translate()}}
\item \href{#method-Translator-get_translation}{\code{Translator$get_translation()}}
\item \href{#method-Translator-get_text}{\code{Translator$get_text()}}
\item \href{#method-Translator-set_text}{\code{Translator$set_text()}}
\item \href{#method-Translator-set_texts}{\code{Translator$set_texts()}}
\item \href{#method-Translator-set_native_languages}{\code{Translator$set_native_languages()}}
\item \href{#method-Translator-rm_text}{\code{Translator$rm_text()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translator-new"></a>}}
\if{latex}{\out{\hypertarget{method-Translator-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{\link{Translator}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$new(id = uuid(), algorithm = constant("algorithms"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{A non-empty and non-\link[base:NA]{NA} character string. A globally
unique identifier for the \code{\link{Translator}} object. Beware of
plausible collisions when using user-defined values.}

\item{\code{algorithm}}{A non-empty and non-\link[base:NA]{NA} character string
equal to \code{"sha1"}, or \code{"utf8"}. The algorithm to use when hashing
source information for identification purposes.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{\link[R6:R6Class]{R6}} object of class \code{\link{Translator}}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Consider using translator() instead.
tr <- Translator$new()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translator-translate"></a>}}
\if{latex}{\out{\hypertarget{method-Translator-translate}{}}}
\subsection{Method \code{translate()}}{
Translate text. Consider using \code{\link[=translate]{translate()}} instead
of this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$translate(
  ...,
  lang = language_get(),
  concat = constant("concat"),
  source_lang = language_source_get()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Any number of literal character vectors. The source text to
translate. Values can be empty and/or \link[base:NA]{NA}, but this may lead
to unexpected results.}

\item{\code{lang}}{A non-empty and non-\link[base:NA]{NA} character string. The
underlying language.

A language is usually a code (of two or three letters) for a native
language name. While users retain full control over codes, it is best
to use language codes stemming from well-known schemes such as
\href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47}, or
\href{https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes}{ISO 639-1}
to maximize portability and cross-compatibility.}

\item{\code{concat}}{A non-empty and non-\link[base:NA]{NA} character string used to
concatenate values passed to \code{...}.}

\item{\code{source_lang}}{A non-empty and non-\link[base:NA]{NA} character string. The
language of the (untranslated) source text. See argument \code{lang} for more
information.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Since it can be detected by \code{\link[=find_source]{find_source()}}, \code{\link[=translate]{translate()}} is the
preferred interface to this method.

Values passed to \code{...} are first \link[=normalize]{normalized},
and then \link[=hash]{hashed}. The translation that corresponds to
the resulting hash and \code{lang} pair is fetched via method
\code{\link[=Translator]{Translator$get_translation()}}. Argument \code{lang} will
not be validated if the resulting hash has no corresponding
\code{\link{Text}} object.
}

\subsection{Returns}{
A character string, or \code{NULL} if the underlying translation
is unavailable.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{tr <- Translator$new()
tr$set_text(en = "Hello, world!", fr = "Bonjour, monde!")

# Consider using translate() instead.
tr$translate("Hello, world!", lang = "en")  ## Outputs "Hello, world!"
tr$translate("Hello, world!", lang = "fr")  ## Outputs "Bonjour, monde!"
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translator-get_translation"></a>}}
\if{latex}{\out{\hypertarget{method-Translator-get_translation}{}}}
\subsection{Method \code{get_translation()}}{
Extract a translation, or source texts.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$get_translation(hash = "", lang = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hash}}{A non-empty and non-\link[base:NA]{NA} character string. The
unique identifier of the requested source text, or its underlying
\code{\link{Text}} object.}

\item{\code{lang}}{A non-empty and non-\link[base:NA]{NA} character string. The
underlying language.

A language is usually a code (of two or three letters) for a native
language name. While users retain full control over codes, it is best
to use language codes stemming from well-known schemes such as
\href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47}, or
\href{https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes}{ISO 639-1}
to maximize portability and cross-compatibility.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character string. \code{NULL} is returned if the requested
translation is not available (either \code{hash} or \code{lang} is not
registered).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{tr <- Translator$new()
tr$set_text(en = "Hello, world!")

# Consider using translate() instead.
tr$get_translation("256e0d7", "en")  ## Outputs "Hello, world!"
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translator-get_text"></a>}}
\if{latex}{\out{\hypertarget{method-Translator-get_text}{}}}
\subsection{Method \code{get_text()}}{
Extract a \code{\link{Text}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$get_text(hash = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hash}}{A non-empty and non-\link[base:NA]{NA} character string. The
unique identifier of the requested source text, or its underlying
\code{\link{Text}} object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{Text}} object, or \code{NULL}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{tr <- Translator$new()
tr$set_text(en = "Hello, world!")

tr$get_translation("256e0d7", "en")  ## Outputs "Hello, world!"
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translator-set_text"></a>}}
\if{latex}{\out{\hypertarget{method-Translator-set_text}{}}}
\subsection{Method \code{set_text()}}{
Simultaneously create and register a \code{\link{Text}}
object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$set_text(..., source_lang = language_source_get())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Passed as is to \code{\link[=text]{text()}}.}

\item{\code{source_lang}}{Passed as is to \code{\link[=text]{text()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{NULL}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{tr <- Translator$new()

tr$set_text(en = "Hello, world!", location())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translator-set_texts"></a>}}
\if{latex}{\out{\hypertarget{method-Translator-set_texts}{}}}
\subsection{Method \code{set_texts()}}{
Register one or more \code{\link{Text}} objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$set_texts(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Any number of \code{\link{Text}} objects.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method calls \code{\link[=merge_texts]{merge_texts()}} to merge all
values passed to \code{...} together with previously registered
\code{\link{Text}} objects. The underlying registered source
texts, translations, and \code{\link{Location}} objects
won't be duplicated.
}

\subsection{Returns}{
A \code{NULL}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Set source language.
language_source_set("en")

tr <- Translator$new()

# Create Text objects.
txt1 <- text(
  location("a", 1L, 2L, 3L, 4L),
  en = "Hello, world!",
  fr = "Bonjour, monde!")

txt2 <- text(
  location("b", 5L, 6L, 7L, 8L),
  en = "Farewell, world!",
  fr = "Au revoir, monde!")

tr$set_texts(txt1, txt2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translator-set_native_languages"></a>}}
\if{latex}{\out{\hypertarget{method-Translator-set_native_languages}{}}}
\subsection{Method \code{set_native_languages()}}{
Map a language code to a native language name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$set_native_languages(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Any number of named, non-empty, and non-\link[base:NA]{NA}
character strings. Names are codes and values are native
languages. See field \code{native_languages} for more information.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{NULL}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{tr <- Translator$new()

tr$set_native_languages(en = "English", fr = "Français")

# Remove existing entries.
tr$set_native_languages(fr = NULL)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translator-rm_text"></a>}}
\if{latex}{\out{\hypertarget{method-Translator-rm_text}{}}}
\subsection{Method \code{rm_text()}}{
Remove a registered location.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$rm_text(hash = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hash}}{A non-empty and non-\link[base:NA]{NA} character string
identifying the \code{\link{Text}} object to be removed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{NULL}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{tr <- Translator$new()
tr$set_text(en = "Hello, world!")

tr$rm_text("256e0d7")
}
\if{html}{\out{</div>}}

}

}
}
