% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ukkri.R
\name{ukkdri}
\alias{ukkdri}
\title{UK Kidney Donor Risk Index (NHSBT, 2019 version)}
\usage{
ukkdri(age, height, htn, sex, cmv, gfr, hdays)
}
\arguments{
\item{age}{numeric vector of donor age in years}

\item{height}{numeric vector of donor height in cm}

\item{htn}{numeric vector of whether donor history of hypertension (1 = yes, 0 = no)}

\item{sex}{character vector of donor sex ("F" = female, "M" = male)}

\item{cmv}{numeric vector of whether donor CMV IgG positive (1 = yes, 0 = no)}

\item{gfr}{numeric vector of donor eGFR at time of donation}

\item{hdays}{numeric vector of number of days donor in hospital before donation}
}
\value{
numeric vector of UK Kidney Donor Risk Index values (2019 version)
}
\description{
A vectorised function to calculate the UK Kidney Donor Risk Index as used in the new
national kidney matching scheme implemented in September 2019.
}
\details{
The UK KDRI is documented in the UK kidney matching policy which can be found on the
NHS Blood & Transplant ODT website at www.odt.nhs.uk
}
\examples{
ukkdri(age = 50, height = 170, htn = 1, sex = "F", cmv = 0, gfr = 90, hdays = 2)
}
