% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqic_2.R
\name{seqic_indicator_2}
\alias{seqic_indicator_2}
\title{SEQIC Indicator 2 – Missing Incident Time}
\usage{
seqic_indicator_2(
  data,
  unique_incident_id,
  level,
  included_levels = c("I", "II", "III", "IV"),
  incident_time,
  groups = NULL,
  calculate_ci = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing trauma incident records.}

\item{unique_incident_id}{Unique identifier for each record.}

\item{level}{Column indicating the trauma center designation level (e.g., I,
II, III, IV).}

\item{included_levels}{Character vector indicating what facility levels to
include in the analysis.  Defaults to \code{c("I", "II", "III", "IV")}.}

\item{incident_time}{The time the patient's injury occurred.}

\item{groups}{Additional columns passed as a vector of strings to
\code{dplyr::summarize()} via the \code{.by} argument for grouped summaries. Defaults
to \code{NULL}.}

\item{calculate_ci}{If \code{NULL}, 95\% confidence intervals will not be
calculated for the performance estimates.  Otherwise, options of "wilson"
or "clopper-pearson" can be supplied to utilize the corresponding methods
to calculate the confidence intervals for the proportions. Defaults to
\code{NULL}.}

\item{...}{
  Arguments passed on to \code{\link[nemsqar:nemsqa_binomial_confint]{nemsqar::nemsqa_binomial_confint}}
  \describe{
    \item{\code{conf.level}}{Numeric value between 0 and 1 indicating the confidence
level. Defaults to 0.95 (95\% confidence interval).}
    \item{\code{correct}}{Logical, indicating whether to apply continuity correction for
Wilson intervals. Defaults to \code{TRUE}.}
  }}
}
\value{
A tibble summarizing SEQIC Indicator 2 results. Includes numerator,
denominator, and performance rate for the indicator. 95\% confidence
intervals are provided optionally.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function calculates System Evaluation and Quality Improvement Committee
(SEQIC) Indicator 2. This indicator evaluates the proportion of trauma
incidents with missing documented incident time across Level I–IV trauma
centers.
}
\details{
This function:
\itemize{
\item Filters trauma records to those with a trauma center level of I–IV.
\item Deduplicates by \code{unique_incident_id} to ensure one record per
incident.
\item Calculates the proportion of cases missing \code{incident_time}.
}
}
\note{
Users must ensure appropriate column names are passed and data is
pre-processed to include the necessary fields without missing critical
identifiers or timestamps.
}
\examples{

# Packages
library(dplyr)
library(traumar)

# Data
data <- tibble::tibble(
  incident_id = as.character(101:106),
  trauma_level = c("I", "II", "III", "IV", "II", "I"),
  incident_time = as.POSIXct(c("2023-01-01 12:00", NA, "2023-01-02 14:15",
                               NA, "2023-01-03 09:30", "2023-01-04 16:45"))
)

# Run the function
traumar::seqic_indicator_2(
  data = data,
  unique_incident_id = incident_id,
  level = trauma_level,
  incident_time = incident_time,
  calculate_ci = "clopper-pearson"
)

}
\author{
Nicolas Foss, Ed.D., MS
}
