% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip-methods.R
\name{rmTips}
\alias{rmTips}
\title{Remove tips from a tree}
\usage{
rmTips(tree, tids, drp_intrnl = TRUE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{tids}{tip IDs}

\item{drp_intrnl}{Boolean, drop internal branches, default FALSE}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Returns a tree with a tip ID(s) removed
}
\details{
Removes tips in a tree. Set drp_intrnl to FALSE to convert
internal nodes into new tips. Warning: do not use this function to remove
internal nodes, this create a corrupted tree.
}
\examples{
library(treeman)
tree <- randTree(10)
tree <- rmTips(tree, 't1')
summary(tree)
# running the function using an internal
# node will create a corrupted tree
tree <- rmTips(tree, 'n3')
# run summary() to make sure a change has
# not created a corruption
#summary(tree)
}
\seealso{
\code{\link{addTip}}, \code{\link{rmNodes}},
 \url{https://github.com/DomBennett/treeman/wiki/manip-methods}
}
