% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectCharacterType.R
\name{detectCharacterType}
\alias{detectCharacterType}
\title{Function to detect whether a character is continuous or discrete}
\usage{
detectCharacterType(dat, repeatsAsDiscrete = TRUE, cutoff = 0.1)
}
\arguments{
\item{dat}{A vector of data}

\item{repeatsAsDiscrete}{If TRUE, consider numeric variables that repeat values exactly as discrete; see cutoff}

\item{cutoff}{Cutoff value for deciding if numeric data might actually be discrete: if nlev is the number of levels and n the length of dat, then nlev / n should exceed cutoff, or the data will be classified as discrete}
}
\value{
Either "discrete" or "continuous"
}
\description{
Function to detect whether a character is continuous or discrete
}
\examples{
data(anolis)
detectCharacterType(anolis$dat[,1])
}

