% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/findGroves.R
\name{findGroves}
\alias{findGroves}
\title{Identify clusters of similar trees}
\usage{
findGroves(x, method = treeVec, nf = NULL, clustering = "ward.D2",
  nclust = NULL, ...)
}
\arguments{
\item{x}{an object of the class multiPhylo}

\item{method}{a function outputting the summary of a tree (phylo object) in the form of a vector}

\item{nf}{the number of principal components to retain}

\item{clustering}{a character string indicating the clustering method to be used; defaults to Ward's method; see argument \code{method} in \code{?hclust} for more details.}

\item{nclust}{an integer indicating the number of clusters to find; if not provided, an interactive process based on cutoff threshold selection is used.}

\item{...}{further arguments to be passed to \code{treescape}}
}
\value{
A list containing:
\itemize{
 \item groups: a factor defining groups of trees
 \item treescape: the output of treescape
}
}
\description{
This function uses hierarchical clustering on principal components output by \code{\link{treescape}} to identify groups of similar trees. Clustering relies on \code{\link{hclust}}, using Ward's method by default.
}
\examples{
if(require("adegenet") && require("adegraphics")){
## load data
data(woodmiceTrees)

## run findGroves: treescape+clustering
res <- findGroves(woodmiceTrees, nf=5, nclust=6)

## plot results on first 2 axes
PCs <- res$treescape$pco$li
s.class(PCs, fac=res$groups, col=funky(6))

## using plotGroves
plotGroves(res)
}
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
\seealso{
\code{\link{plotGroves}} to display results
}

