% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blum.R
\name{sshape}
\alias{sshape}
\title{s shape statistic of (im)balance.}
\usage{
sshape(phy, normalization = FALSE)
}
\arguments{
\item{phy}{phylogeny or ltable}

\item{normalization}{because the sshape statistic sums over all nodes,
the resulting statistic tends to be correlated with the number of extant
tips. Normalization can be performed by dividing by the number of extant
tips.}
}
\value{
s shape statistic of imbalance
}
\description{
The s shape statistic of imbalance (also known as the Blum
statistic, see \link{blum}) calculates the sum of \eqn{log(N-1)} over all
internal nodes, where N represents the total number of extant tips connected
to that node. An alternative implementation can be found in the Castor R
package.
}
\examples{
simulated_tree <- ape::rphylo(n = 10, birth = 1, death = 0)
  balanced_tree <- treestats::create_fully_balanced_tree(simulated_tree)
  unbalanced_tree <- treestats::create_fully_unbalanced_tree(simulated_tree)
  sshape(balanced_tree)
  sshape(unbalanced_tree) # should be higher
}
\references{
M. G. B. Blum and O. Francois (2006). Which random processes
describe the Tree of Life? A large-scale study of phylogenetic tree
imbalance. Systematic Biology. 55:685-691.
}
