% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/modifiedRecursive.R
\name{modifiedRecursive}
\alias{modifiedRecursive}
\title{modifiedRecursive trimming procedure.}
\usage{
modifiedRecursive(data, minRT, omitErrors = TRUE, digits = 3)
}
\arguments{
\item{data}{A data frame. It must contain columns named "participant",
"condition", "rt", and "accuracy". The RT can be in seconds
(e.g., 0.654) or milliseconds (e.g., 654). Typically, "condition" will
consist of strings. "accuracy" must be 1 for correct and 0 for error
responses.}

\item{minRT}{The lower criteria for acceptable response time. Must be in
the same form as rt column in data frame (e.g., in seconds OR milliseconds).
All RTs below this value are removed before proceeding with SD trimming.}

\item{omitErrors}{If set to TRUE, error trials will be removed before
conducting trimming procedure. Final data returned will not be influenced
by errors in this case.}

\item{digits}{How many decimal places to round to after trimming?}
}
\description{
\code{modifiedRecursive} takes a data frame of RT data and returns trimmed rt
data that fall below a set standard deviation above the each participant's
mean for each condition, with the criterion changing as more trials are
removed,  as described in van Selst & Jolicoeur (1994).
}
\examples{
# load the example data that ships with trimr
data(exampleData)

# perform the trimming, returning mean RT
trimmedData <- modifiedRecursive(data = exampleData, minRT = 150)
}
\references{
Van Selst, M. & Jolicoeur, P. (1994). A solution to the effect
of sample size on outlier elimination. \emph{Quarterly Journal of Experimental
Psychology, 47} (A), 631-650.
}

