% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_mahal.R
\name{dist_mahal}
\alias{dist_mahal}
\title{Make Mahalanobis distance matrix}
\usage{
dist_mahal(X, z, st, rank_based = FALSE)
}
\arguments{
\item{X}{Covariate matrix to be used in calculating distances}

\item{z}{Vector of treatment assignments}

\item{st}{Vector of stratum assignments, should be denoted by consecutive integers starting from 1}

\item{rank_based}{Whether to use rank based Mahalanobis distance or not}
}
\value{
List of squared Mahalanobis distance matrices between each pair of treated-control units in a stratum.
     There is one entry in the list for each stratum.
     This entry is a distance matrix with a row for each treated unit and a column
     for each control unit in the stratum.
}
\description{
Make Mahalanobis distance matrix
}
\examples{
# Generate some data
set.seed(1)
n <- 40
x <- rnorm(n, 0, 1)
nt <- floor(n * 0.4)
nc <- n - nt
z <- c(rep(1, nt), rep(0, nc))
# Create some strata
ps <- glm(z ~ x, family = binomial)$fitted.values
ps_st <- cut(ps, c(0, quantile(ps, 1/3 * 1:2), 1), labels = 1:3)
# Create a list of distance matrices, one for each stratum
dist <- dist_mahal(data.frame(x = x), z, ps_st)

}
