% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triples_st.R
\name{triples_st}
\alias{triples_st}
\title{Create a triples match for a single stratum}
\usage{
triples_st(cost, z, solver = "rrelaxiv")
}
\arguments{
\item{cost}{Matrix of distances between treated (rows) and control (columns) units within the stratum}

\item{z}{Vector of treatment assignments for units within the stratum (0 for control, 1 for treated)}

\item{solver}{Solver to use for the network problem. Either 'rrelaxiv' or 'rlemon'.
'rrelaxiv' can be downloaded from "https://github.com/josherrickson/rrelaxiv/"}
}
\value{
Named list with three elements: `m` contains the triples match. This is in the form of a
 data.frame with number of rows equal to the number of triples and 7 columns specifying the
 match number, the names of the three units within the match, the costs of the two
 treated-control pairs within the match, and the number of treated units. `obj`
 contains the total objective from the network optimization and `bound` contains
 a loose lower bound on the objective of the optimal match.
}
\description{
Create a triples match for a single stratum
}
\examples{
set.seed(10)
n <- 20
x <- rnorm(n, 0, 1)
nt <- floor(n * 0.62)
nc <- n - nt
z <- c(rep(1, nt), rep(0, nc))
dist <- dist_mahal(data.frame(x = x), z, rep(1, n))[[1]]
triples_st(cost = dist, z = z, solver = "rlemon")

}
