% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_variables.R
\name{group_variables}
\alias{group_variables}
\title{Helper function that combines clustering variables and creating aspect list}
\usage{
group_variables(x, h, clust_method = "complete")
}
\arguments{
\item{x}{hclust object}

\item{h}{correlation value for tree cutting}

\item{clust_method}{the agglomeration method to be used
see \code{\link[stats]{hclust}} methods}
}
\value{
list with aspect
}
\description{
Divides correlated features into groups, called aspects. Division is based on
correlation cutoff level.
}
\examples{
library("DALEX")
dragons_data <- dragons[,c(2,3,4,7,8)]
group_variables(dragons_data, h = 0.5, clust_method = "complete")

}
