% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_.R, R/ts_apply.R
\name{ts_}
\alias{ts_}
\alias{load_suggested}
\alias{ts_}
\alias{ts_}
\alias{ts_apply}
\title{Constructing ts-Functions}
\usage{
load_suggested(pkg)

ts_(fun, class = "ts", vectorize = FALSE, reclass = TRUE)

ts_apply(x, fun, ...)
}
\arguments{
\item{pkg}{external package, to be suggested (automatically added by \code{ts_})
\code{predict()}. (See examples)}

\item{fun}{function, to be made available to all time series classes}

\item{class}{class that the function uses as its first argument}

\item{vectorize}{should the function be vectorized? (not yet implemented)}

\item{reclass}{logical, should the new function return the same same
ts-boxable output as imputed?}

\item{x}{ts-boxable time series, an object of class \code{ts}, \code{xts}, \code{zoo}, \code{data.frame}, \code{data.table}, \code{tibble}, \code{tsibble} or \code{timeSeries}.}

\item{...}{arguments passed to subfunction}
}
\value{
A function that accepts ts-boxable time series as an input.
}
\description{
\code{ts_} turns an existing function into a function that can deal with
ts-boxable time series objects.
}
\details{
The \code{ts_} function is a constructor function for tsbox time series functions. It
can be used to wrap any function that works with time series. The default is set
to R base \code{"ts"} class. \code{ts_} deals with the conversion stuff, 'vectorizes' the
function so that it can be used with multiple time series.
}
\examples{
\donttest{
ts_(rowSums)(ts_c(mdeaths, fdeaths))
ts_plot(mean = ts_(rowMeans)(ts_c(mdeaths, fdeaths)), mdeaths, fdeaths)
ts_(function(x) predict(prcomp(x)))(ts_c(mdeaths, fdeaths))
ts_(function(x) predict(prcomp(x, scale = TRUE)))(ts_c(mdeaths, fdeaths))
ts_(dygraphs::dygraph, class = "xts")

# attach series to serach path
ts_attach <- ts_(attach, class = "tslist", reclass = FALSE)
ts_attach(EuStockMarkets)
ts_plot(DAX, SMI)
detach()
}
}
\seealso{
\link{ts_examples}, for a few useful examples of functions generated by \code{ts_}.
}
