% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{tile}
\alias{tile}
\alias{tile.default}
\alias{tile.data.frame}
\alias{tiler}
\title{Tiling window calculation}
\usage{
tile(x, .f, ..., size = 1)

\method{tile}{default}(x, .f, ..., size = 1)

\method{tile}{data.frame}(x, .f, ..., size = 1, deframe = TRUE)

tiler(x, size = 1)
}
\arguments{
\item{x}{A vector of numerics, or data frame.}

\item{.f}{A function or one-sided formula using purrr-like syntax. If a
formula, it is converted to a function.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{size}{An integer for window size.}

\item{deframe}{TRUE a list is returned. FALSE returns a data frame.}
}
\description{
\code{tile()} is an S3 method to carry out tiling window calculation; \code{tiler()}
splits the input \code{x} to a list according to the window size.
}
\examples{
# tiling over a vector ----
x <- 1:10
tile(x, sum, size = 3)
tile(x, ~ sum(.), size = 3)
tiler(x, size = 3)

# tiling over a 2-day window for hourly data ----
sx <- pedestrian \%>\%
  filter(Sensor == "Southern Cross Station", Date <= as.Date("2015-01-10"))
sx \%>\% 
  tile(~ quantile(.$Count), size = 48, deframe = FALSE)
}
\seealso{
\link{slide} for sliding window with overlapping observations;
\link{stretch} for expanding more observations
}
