% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{count_gaps}
\alias{count_gaps}
\title{Count implicit gaps}
\usage{
count_gaps(
  .data,
  .full = FALSE,
  .name = c(".from", ".to", ".n"),
  .start = NULL,
  .end = NULL
)
}
\arguments{
\item{.data}{A tsibble.}

\item{.full}{\itemize{
\item \code{FALSE} inserts \code{NA} for each keyed unit within its own period.
\item \code{TRUE} fills \code{NA} over the entire time span of the data (a.k.a. fully balanced panel).
\item \code{start()} pad \code{NA} to the same starting point (i.e. \verb{min(<index>)}) across units.
\item \code{end()} pad \code{NA} to the same ending point (i.e. \verb{max(<index>)}) across units.
}}

\item{.name}{Strings to name new columns.}

\item{.start, .end}{Set custom starting/ending time that allows to expand the
existing time spans.}
}
\value{
A tibble contains:
\itemize{
\item the "key" of the \code{tbl_ts}
\item ".from": the starting time point of the gap
\item ".to": the ending time point of the gap
\item ".n": the number of implicit missing observations during the time period
}
}
\description{
Count implicit gaps
}
\examples{
ped_gaps <- pedestrian \%>\%
  count_gaps(.full = TRUE)
ped_gaps
if (!requireNamespace("ggplot2", quietly = TRUE)) {
  stop("Please install the ggplot2 package to run these following examples.")
}
library(ggplot2)
ggplot(ped_gaps, aes(x = Sensor, colour = Sensor)) +
  geom_linerange(aes(ymin = .from, ymax = .to)) +
  geom_point(aes(y = .from)) +
  geom_point(aes(y = .to)) +
  coord_flip() +
  theme(legend.position = "bottom")
}
\seealso{
Other implicit gaps handling: 
\code{\link{fill_gaps}()},
\code{\link{has_gaps}()},
\code{\link{scan_gaps}()}
}
\concept{implicit gaps handling}
