% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.ArcCount}
\alias{plot.Valmod}
\alias{plot.MatrixProfile}
\alias{plot.MultiMatrixProfile}
\alias{plot.SimpleMatrixProfile}
\alias{plot.Fluss}
\alias{plot.Chain}
\alias{plot.Discord}
\alias{plot.Motif}
\alias{plot.MultiMotif}
\alias{plot.Salient}
\title{Plot a TSMP object}
\usage{
\method{plot}{ArcCount}(x, data, type = c("data", "matrix"),
  exclusion_zone = NULL, edge_limit = NULL,
  threshold = stats::quantile(x$cac, 0.1), main = "Arcs Discover",
  xlab = "index", ylab = "", ...)

\method{plot}{Valmod}(x, ylab = "distance", xlab = "index",
  main = "Valmod Matrix Profile", ...)

\method{plot}{MatrixProfile}(x, ylab = "distance", xlab = "index",
  main = "Unidimensional Matrix Profile", ...)

\method{plot}{MultiMatrixProfile}(x, ylab = "distance", xlab = "index",
  main = "Multidimensional Matrix Profile", ...)

\method{plot}{SimpleMatrixProfile}(x, ylab = "distance",
  xlab = "index", main = "SiMPle Matrix Profile", ...)

\method{plot}{Fluss}(x, data, type = c("data", "matrix"),
  main = "Fast Low-cost Unipotent Semantic Segmentation",
  xlab = "index", ylab = "", ...)

\method{plot}{Chain}(x, data, type = c("data", "matrix"),
  main = "Chain Discover", xlab = "index", ylab = "", ...)

\method{plot}{Discord}(x, data, type = c("data", "matrix"), ncol = 3,
  main = "Discord Discover", xlab = "index", ylab = "", ...)

\method{plot}{Motif}(x, data, type = c("data", "matrix"), ncol = 3,
  main = "MOTIF Discover", xlab = "index", ylab = "", ...)

\method{plot}{MultiMotif}(x, data, type = c("data", "matrix"),
  ncol = 3, main = "Multidimensional MOTIF Discover", xlab = "index",
  ylab = "", ...)

\method{plot}{Salient}(x, data, main = "Salient Subsections",
  xlab = "index", ylab = "", ...)
}
\arguments{
\item{x}{a Matrix Profile}

\item{data}{the data used to build the Matrix Profile, if not embedded to it.}

\item{type}{"data" or "matrix". Choose what will be plotted.}

\item{exclusion_zone}{if a \code{number} will be used instead of Matrix Profile's. (Default is \code{NULL}).}

\item{edge_limit}{if a \code{number} will be used instead of Matrix Profile's exclusion zone. (Default is \code{NULL}).}

\item{threshold}{the maximum value to be used to plot.}

\item{main}{a \code{string}. Main title.}

\item{xlab}{a \code{string}. X label.}

\item{ylab}{a \code{string}. Y label.}

\item{...}{further arguments to be passed to \code{\link[=plot]{plot()}}. See \code{\link[=par]{par()}}.}

\item{ncol}{an \code{int}. Number of columns to plot Motifs.}
}
\value{
None
}
\description{
Plot a TSMP object
}
\examples{

mp <- tsmp(mp_toy_data$data[1:200, 1], window_size = 30, verbose = 0)
plot(mp)
}
\keyword{hplot}
