% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_projection.R
\name{ts_projection}
\alias{ts_projection}
\title{Time Series Projection}
\usage{
ts_projection(ts)
}
\arguments{
\item{ts}{Matrix or data.frame containing a \code{ts_data} representation.}
}
\value{
A \code{ts_projection} object with two elements: \verb{$input} and \verb{$output}.
}
\description{
Split a \code{ts_data} (sliding windows) into input features and
output targets for modeling.
}
\details{
For a multi-column \code{ts_data}, returns all but the last column as
inputs and the last column as the output. For a single-row matrix, returns
\code{ts_data}-wrapped inputs/outputs preserving names and window size.
}
\examples{
# Setting up a ts_data and projecting (X, y)
# Load example dataset and create windows
data(tsd)
ts <- ts_data(tsd$y, 10)

io <- ts_projection(ts)

# Input data (features)
ts_head(io$input)

# Output data (target)
ts_head(io$output)
}
