% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/berkowitz.R
\name{berkowitz_test}
\alias{berkowitz_test}
\title{Berkowitz Forecast Density Test}
\usage{
berkowitz_test(x, lags = 1, ...)
}
\arguments{
\item{x}{a series representing the PIT transformed actuals given the forecast
values.}

\item{lags}{the number of autoregressive lags (positive and greater than 0).}

\item{...}{additional arguments passed to the arima function which estimates
the unrestricted model.}
}
\value{
An object of class \dQuote{tstest.berkowitz} which has a print and
as_flextable method.
}
\description{
The forecast density test of Berkowitz (2001).
}
\examples{
library(tsdistributions)
data(garch_forecast)
x <- pdist('jsu', q = garch_forecast$actual, mu = garch_forecast$forecast,
sigma = garch_forecast$sigma, skew = garch_forecast$skew,
shape = garch_forecast$shape)
print(berkowitz_test(x))

}
\references{
\insertRef{Berkowitz2001}{tstests}

\insertRef{Jarque1987}{tstests}
}
