% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_args.R
\name{tune_args}
\alias{tune_args}
\alias{tune_args.model_spec}
\alias{tune_args.recipe}
\alias{tune_args.step}
\alias{tune_args.check}
\alias{tune_args.workflow}
\title{Determine arguments tagged for tuning}
\usage{
tune_args(object, ...)

\method{tune_args}{model_spec}(object, full = FALSE, ...)

\method{tune_args}{recipe}(object, full = FALSE, ...)

\method{tune_args}{step}(object, full = FALSE, ...)

\method{tune_args}{check}(object, full = FALSE, ...)

\method{tune_args}{workflow}(object, ...)
}
\arguments{
\item{object}{A \code{model_spec}, \code{recipe}, \code{workflow} or other object.}

\item{...}{Not currently used.}

\item{full}{A single logical. Should all possible tunable parameters be
returned? If \code{FALSE}, then only the parameters that
are actually tunable are returned.}
}
\value{
A tibble with columns for the parameter name (\code{name}), whether it
contains \emph{any} tunable value (\code{tune}), the \code{id} for the parameter (\code{id}),
and the information on where the parameter was located (\code{source}).
}
\description{
\code{\link[=tune_args]{tune_args()}} takes a model specification or a recipe and returns a tibble
of information on all possible tunable arguments and whether or not they
are actually tunable.
}
\details{
The \code{source} column is determined differently depending on whether a \code{model_spec}
or a \code{recipe} is used (with additional detail on the type).

The \code{id} field has any identifier that was passed to \code{\link[=tune]{tune()}} (e.g.
\code{tune("some note")}). If not additional detail was used in that function,
the \code{id} field reverts to the name of the parameters.
}
\examples{
\donttest{
library(recipes)

recipe(mpg ~ ., data = mtcars) \%>\%
  step_knnimpute(all_predictors(), neighbors = tune()) \%>\%
  step_pca(all_predictors(), num_comp = tune()) \%>\%
  tune_args()

recipe(mpg ~ ., data = mtcars) \%>\%
  step_ns(disp, deg_free = tune("disp df")) \%>\%
  step_ns(wt, deg_free = tune("wt df")) \%>\%
  tune_args()

recipe(mpg ~ ., data = mtcars) \%>\%
  step_normalize(all_predictors()) \%>\%
  tune_args()

library(parsnip)

boost_tree(trees = tune(), min_n = tune()) \%>\%
  set_engine("xgboost") \%>\%
  tune_args()

boost_tree(trees = tune(), min_n = tune()) \%>\%
  set_engine("C5.0", rules = TRUE) \%>\%
  tune_args()
}
}
\keyword{internal}
