% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_tupoisPN.R
\name{summary.tuts_poisPN}
\alias{summary.tuts_poisPN}
\title{Prints summary tables of tuts_poisPN objects}
\usage{
\method{summary}{tuts_poisPN}(object, ...)
}
\arguments{
\item{object}{A tuts_poisPN object.}

\item{...}{list of optional parameters. The list contains burn-in parameter
ranging from 0 to 0.5, with the default value burn=0, and the credible interval parameter
ranging between 0.5 and 1, with the default CI=0.99.}
}
\description{
\code{summary.tuts_poisPN} prints summary tables of tuts_poisPN objects.
}
\examples{
# Note: Most of models included in tuts package are computationally intensive. In the example
# below I set parameters to meet CRAN’s testing requirement of maximum 5 sec per example.
# A more practical example would contain N=50 in the first line of the code and n.sim=10000.

#1. Import or simulate the data (a simulation is chosen for illustrative purposes):
DATA=simtuts(N=10,Harmonics=c(4,0,0), sin.ampl=c(10,0, 0), cos.ampl=c(0,0,0),
            trend=0,y.sd=2, ti.sd=0.2)
y=DATA$observed$y.obs
y=round(y-min(y))
ti.mu=DATA$observed$ti.obs.tnorm
ti.sd= rep(0.2, length(ti.mu))

#2. Fit the model:
polyorder=2
n.sim=1000
PPN=tupoispn(y=y,ti.mu=ti.mu,ti.sd=ti.sd,polyorder=polyorder,n.sim=n.sim,CV=FALSE)

#3. Generate summary results (optional parameters are listed in brackets):
summary(PPN)                           # Summary results (burn, CI).

}
