% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps.xgb.r
\name{ps.xgb}
\alias{ps.xgb}
\title{Gradient boosted propensity score estimation}
\usage{
ps.xgb(
  formula = formula(data),
  strata = NULL,
  data,
  params,
  file = NULL,
  max.steps = Inf,
  iters.per.step = 100,
  id.var,
  min.iter = 1000,
  min.width = 500,
  verbose = TRUE,
  save.model = FALSE,
  weights = NULL,
  linkage = TRUE
)
}
\arguments{
\item{formula}{An object of class \link{formula}: a symbolic
description of the propensity score model to be fit with the treatment
indicator on the left side of the formula and the
variables to be balanced on the right side.}

\item{strata}{An optional factor variable identifying the strata.
If specified, balance is optimized within strata.}

\item{data}{A dataset.}

\item{params}{\link{xgboost} parameters.}

\item{file}{An optional character string naming a file to save intermediate results.}

\item{max.steps}{An integer specifying the maximum number of steps to take.
Note that \code{max.steps}*\code{iters.per.step} must be greater than or equal to \code{min.iter}. Default: Inf.}

\item{iters.per.step}{An integer specifying the number of iterations to add
to the model at each step of algorithm. Note that \code{max.steps}*\code{iters.per.step} must be greater than or equal to \code{min.iter}. Default: 100.}

\item{id.var}{A variable that uniquely identifies observations.}

\item{min.iter}{An integer specifying the minimum number of iterations before checking for convergence.
Note that \code{max.steps}*\code{iters.per.step} must be greater than or equal to \code{min.iter}. Default: 1000.}

\item{min.width}{An integer specifying the minimum number of iterations between the current
number of iterations and the optimal value. Default: 500.}

\item{verbose}{A logical value indicating if the function should update
the user on its progres Default: TRUE.}

\item{save.model}{A logical value indicating if the xgboost model be saved as part of the output object. Default: FALSE.}

\item{weights}{An optional variable that identifies user defined weights to be incorporated into the optimization.}

\item{linkage}{An indicator of whether the weighting should be for linkage failure (or nonresponse) versus comparison group construction.
A value of TRUE requests weighting to account for linkage failure, while a value of FALSE
requests weighting for comparison group construction. Default: TRUE.}
}
\value{
Returns an object of class \code{ps.xgb}, a list containing
\itemize{
\item \code{bal.tab} A table summarizing the balance at the optimal number of iterations.
\item \code{es} A table summarizing the standardized differences within strata at the optimal number of iterations.
\item \code{es.max} A table summarizing the maximum absolute standardized difference by strata.
\item \code{es.mean}A table summarizing the mean absolute standardized difference by strata.
\item \code{iter.per.step} Saves the value of \code{iters.per.step} specified by the user.
\item \code{opt.iter} The optimal number of iterations.
\item \code{strata} A list of the strata used in the optimization.
\item \code{weight.data} A dataset containing the unique ID and the optimal weight for each observation.
}
}
\description{
\code{ps.xgb} calculates propensity scores using gradient boosted logistic
regression and diagnoses the resulting propensity scores using a variety of
methods
}
\examples{
# See the vignette for examples.


}
\references{
Dan McCaffrey, G. Ridgeway, Andrew Morral (2004). "Propensity
Score Estimation with Boosted Regression for Evaluating Adolescent
Substance Abuse Treatment", \emph{Psychological Methods} 9(4):403-425.
}
\seealso{
\link[twang:ps]{twang::ps}, \link{xgboost}
}
\concept{twang}
\keyword{nonparametric}
