% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMARconstructor.R
\name{swap_parametrization}
\alias{swap_parametrization}
\title{Swap the parametrization of object of class 'gsmar' defining a gsmar model}
\usage{
swap_parametrization(gsmar, calc_std_errors = TRUE)
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'}, generated by function \code{fitGSMAR()} or \code{GSMAR()}.}

\item{calc_std_errors}{should approximate standard errors be calculated?}
}
\description{
\code{swap_parametrization} swaps the parametrization of object of class '\code{gsmar}'
 to \code{"mean"} if the currect parametrization is \code{"intercept"}, and vice versa.
}
\details{
\code{swap_parametrization()} is convenient tool if you have estimated the model in
 "intercept"-parametrization, but wish to work with "mean"-parametrization in the future, or vice versa.
 In \code{gsmarkit}, for example the approximate standard errors are only available for
 parametrized parameters.
}
\examples{
# GMAR model with intercept parametrization
params13 <- c(1.4, 0.88, 0.26, 2.46, 0.82, 0.74, 5.0, 0.68, 5.2, 0.72, 0.2)
gmar13 <- GSMAR(data=VIX, p=1, M=3, params=params13, model="GMAR")
gmar13

# Swap to mean parametrization
gmar13 <- swap_parametrization(gmar13)
gmar13
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item There are currently no published references for G-StMAR model, but it's a straight forward generalization with
           theoretical properties similar to GMAR and StMAR models.
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{iterate_more}}, \code{\link{get_gradient}},
 \code{\link{get_regime_means}}
}
