% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticPlot.R
\name{profile_logliks}
\alias{profile_logliks}
\title{Plot profile log-likelihoods around the estimates}
\usage{
profile_logliks(gsmar, scale = 0.02, nrows, ncols, precision = 200)
}
\arguments{
\item{gsmar}{a class 'gsmar' object, typically generated by \code{fitGSMAR} or \code{GSMAR}.}

\item{scale}{a numeric scalar specifying the interval plotted for each estimate: the estimate plus-minus \code{abs(scale*estimate)}.}

\item{nrows}{how many rows should be in the plot-matrix? The default is \code{max(ceiling(log2(nparams) - 1), 1)}.}

\item{ncols}{how many columns should be in the plot-matrix? The default is \code{ceiling(nparams/nrows)}.
Note that \code{nrows*ncols} should not be smaller than the number of parameters.}

\item{precision}{at how many points should each profile log-likelihood be evaluated at?}
}
\value{
Only plots to a graphical device and doesn't return anything.
}
\description{
\code{profile_logliks} plots profile log-likelihoods around the estimates.
}
\details{
The red vertical line points the estimate.

  Be aware that the profile log-likelihood function is subject to a numerical error due to limited float-point
  precision when considering extremely large parameter values, say, overly large degrees freedom estimates.
}
\examples{
\donttest{
## The below examples the approximately 15 seconds to run.

# G-StMAR model with one GMAR type and one StMAR type regime
fit42gs <- fitGSMAR(M10Y1Y, p=4, M=c(1, 1), model="G-StMAR",
                    ncalls=1, seeds=4)
profile_logliks(fit42gs)

# GMAR model, graphs zoomed in closer.
fit12 <- fitGSMAR(data=simudata, p=1, M=2, model="GMAR", ncalls=1, seeds=1)
profile_logliks(fit12, scale=0.001)
}
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}(2), 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2023. A mixture autoregressive model based on Student's t-distribution.
         \emph{Communications in Statistics - Theory and Methods}, \strong{52}(2), 499-515.
   \item Virolainen S. 2022. A mixture autoregressive model based on Gaussian and Student's t-distributions.
         Studies in Nonlinear Dynamics & Econometrics, \strong{26}(4) 559-580.
 }
}
\seealso{
\code{\link{quantile_residual_plot}}, \code{\link{diagnostic_plot}}, \code{\link{cond_moment_plot}}, \code{\link{GSMAR}},
 \code{\link{quantile_residual_tests}}, \code{\link{simulate.gsmar}}
}
