% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb_bluedjinn.R
\name{poly_stat}
\alias{poly_stat}
\title{Calculate descriptive statistics of raster as segemented by polygons}
\usage{
poly_stat(rasternames = NULL, spdf = NULL, count = 1, min = 1,
  max = 1, sum = 1, range = 1, mean = 1, var = 1, stddev = 1,
  quantile = 10, parallel = 1,
  proj = "+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs",
  path_run = tempdir(), giLinks = NULL)
}
\arguments{
\item{rasternames}{vector of raster* objects default is NULL}

\item{spdf}{spatial polygon dataframe default is NULL}

\item{count}{0 1 switch}

\item{min}{0 1 switch}

\item{max}{0 1 switch}

\item{sum}{0 1 switch}

\item{range}{0 1 switch}

\item{mean}{0 1 switch}

\item{var}{0 1 switch}

\item{stddev}{0 1 switch}

\item{quantile}{number of quantile}

\item{parallel}{run it parallel default is 1}

\item{proj}{projection string}

\item{path_run}{run time folder for all kind of calculations, by default tempdir()}

\item{giLinks}{list of GI tools cli pathes, default is NULL}
}
\description{
calculate statitiscs of polygon based raster extraction. Returns a spatialpolygon dataframe containing decriptive statistics
}
\examples{
\dontrun{
# required packages
require(uavRst)
require(link2GI)

# create and check the links to the GI software
giLinks<-uavRst::linkAll(linkItems = c("saga","gdal"))
if (giLinks$saga$exist) {

# get the rgb image, chm and training data
url <- "https://github.com/gisma/gismaData/raw/master/uavRst/data/tutorial_data.zip"
utils::download.file(url, file.path(tempdir(),"tutorial_data.zip"))
unzip(zipfile = file.path(tempdir(),"tutorial_data.zip"), exdir = tempdir())

polyStat <- poly_stat("chm_3-3_train1",
                      spdf = "rgb_3-3_train1.shp",
                      giLinks=giLinks)
                      
raster::plot(polyStat)
}
##+}

}
\author{
Chris Reudenbach
}
