% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_fetch_parameters}
\alias{system_fetch_parameters}
\title{Fetch System Parameters}
\usage{
system_fetch_parameters(cfg)
}
\arguments{
\item{cfg}{ubiquity system object}
}
\value{
List of parameters for the selected parameter set
}
\description{
Fetch the parameters of the currently selected parameter set. To switch
between parameter sets use \code{\link{system_select_set}}
}
\examples{
\donttest{
# Creating a system file from the mab_pk example
fr = system_new(file_name        = "system.txt", 
                system_file      = "mab_pk", 
                overwrite        = TRUE, 
                output_directory = tempdir())

# Building the system 
cfg = build_system(system_file  = file.path(tempdir(), "system.txt"),
      output_directory          = file.path(tempdir(), "output"),
      temporary_directory       = tempdir())

# Fetching the default parameter set
parameters = system_fetch_parameters(cfg)
}
}
