% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_check_steady_state}
\alias{system_check_steady_state}
\title{Verify System Steady State}
\usage{
system_check_steady_state(
  cfg,
  parameters = NULL,
  zero_rates = TRUE,
  zero_bolus = TRUE,
  output_times = seq(0, 100, 1),
  offset_tol = .Machine$double.eps * 100,
  derivative_tol = .Machine$double.eps * 100,
  derivative_time = 0
)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{parameters}{optional set of parameters (\code{NULL}) to check at steady state (if set to \code{NULL} then the parameters for the currently selected parameter set will be used)}

\item{zero_rates}{Boolean value to control removing all rate inputs (\code{TRUE})}

\item{zero_bolus}{Boolean value to control removing all bolus inputs (\code{TRUE})}

\item{output_times}{sequence of output times to simulate for offset determination (\code{seq(0,100,1)})}

\item{offset_tol}{maximum percent offset to be considered zero (\code{.Machine$double.eps*100})}

\item{derivative_tol}{maximum derivative value to be considered zero (\code{.Machine$double.eps*100})}

\item{derivative_time}{time to evaluate derivatives to identify deviations (\code{0}), set to \code{NULL} to skip derivative evaluation}
}
\value{
List with the following names
\itemize{
\item \code{steady_state} Boolean indicating weather the system was at steady state
\item \code{states_derivative} Derivatives that had values greater than the \code{derivative_tol}
\item \code{states_simulation} States that had values greater than the \code{offset_tol}
\item \code{som} Simulated output 
\item \code{derivatives} Derivatives
\item \code{states_derivative_NA_NaN} States that had derivatives that evaluated as either NA or NaN
\item \code{states_simulation_NA_NaN} States with simulation values that had either NA or NaN
\item \code{derivative_tc} Data frame with the timecourse of states where the derivative was found to be greater than tolerance (states_derivative)
}
}
\description{
Takes the ubiquity system object and other optional inputs to verify the system is running at steady state. This also provides information that can be helpful in debugging systems not running at steady state.
}
