% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap.R
\name{predict.umap}
\alias{predict.umap}
\title{project data points onto an existing umap embedding}
\usage{
\method{predict}{umap}(object, data, ...)
}
\arguments{
\item{object}{trained object of class umap}

\item{data}{matrix with data}

\item{...}{additional arguments (not used)}
}
\value{
new matrix
}
\description{
project data points onto an existing umap embedding
}
\examples{
# embedd iris dataset using default settings
iris.umap = umap(iris[,1:4])

# create a dataset with structure like iris, but with perturbation
iris.perturbed = iris[,1:4] + matrix(rnorm(nrow(iris)*4, 0, 0.1), ncol=4)

# project perturbed dataset
perturbed.embedding = predict(iris.umap, iris.perturbed)

# output is a matrix with embedding coordinates
head(perturbed.embedding)

}
