% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxRun}
\alias{umxRun}
\title{umxRun}
\usage{
umxRun(model, n = 1, calc_SE = TRUE, calc_sat = TRUE, setValues = FALSE,
  setLabels = FALSE, intervals = FALSE, comparison = NULL,
  setStarts = NULL)
}
\arguments{
\item{model}{The \code{\link{mxModel}} you wish to run.}

\item{n}{The maximum number of times you want to run the model trying to get a code green run (defaults to 1)}

\item{calc_SE}{Whether to calculate standard errors (not used when n = 1)
for the summary (they are not very accurate, so if you use \code{\link{mxCI}} or \code{\link{umxCI}}, you can turn this off)}

\item{calc_sat}{Whether to calculate the saturated and independence models (for raw \code{\link{mxData}} \code{\link{mxModel}}s) (defaults to TRUE - why would you want anything else?)}

\item{setValues}{Whether to set the starting values of free parameters (defaults to F)}

\item{setLabels}{Whether to set the labels (defaults to F)}

\item{intervals}{Whether to run mxCI confindence intervals (defaults to F)}

\item{comparison}{Whether to run umxCompare() after umxRun}

\item{setStarts}{Deprecated way to setValues}
}
\value{
- \code{\link{mxModel}}
}
\description{
umxRun is a version of \code{\link{mxRun}} which can run also set start values, labels, and run multiple times
It can also calculate the saturated and independence likelihoods necessary for most fit indices.
}
\examples{
require(OpenMx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1) # just run: will create saturated model if needed
m1 = umxRun(m1, setValues = TRUE, setLabels = TRUE) # set start values and label all parameters
umxSummary(m1, show = "std")
m1 = mxModel(m1, mxCI("G_to_x1")) # add one CI
m1 = mxRun(m1, intervals = TRUE)
residuals(m1, run = TRUE) # get CIs on all free parameters
confint(m1, run = TRUE) # get CIs on all free parameters
m1 = umxRun(m1, n = 10) # re-run up to 10 times if not green on first run
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Model Building Functions: \code{\link{umxLabel}};
  \code{\link{umxLatent}}; \code{\link{umxPath}};
  \code{\link{umxRAM}}; \code{\link{umxReRun}};
  \code{\link{umxThresholdMatrix}};
  \code{\link{umxValues}};
  \code{\link{umx_fix_first_loadings}};
  \code{\link{umx_fix_latents}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

