% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_rename_file}
\alias{umx_rename_file}
\title{umx_rename_file}
\usage{
umx_rename_file(findStr = NA, replaceStr = NA, baseFolder = "Finder",
  listPattern = NA, test = TRUE, overwrite = FALSE)
}
\arguments{
\item{findStr}{The (regex) string to find, i.e., "c[ao]t"}

\item{replaceStr}{The (regex) replacement string "\1 are not dogs"}

\item{baseFolder}{The folder to search in. If set to "Finder" (and you are on OS X) it will use the current frontmost Finder window. If it is blank, a choose folder dialog will be thrown.}

\item{listPattern}{A pre-filter for files}

\item{test}{Boolean determining whether to change files on disk, or just report on what would have happened (Defaults to test = TRUE)}

\item{overwrite}{Boolean determining if an existing file will be overwritten (Defaults to the safe FALSE)}
}
\value{
-
}
\description{
rename files. On OS X, the function can access the current frontmost Finder window.
The file renaming is fast and, because you can use regular expressions, powerful
}
\examples{
\dontrun{
umx_rename_file(baseFolder = "~/Downloads/", findStr = "", replaceStr = "", test = TRUE)
umx_rename_file("[Ss]eason +([0-9]+)", replaceStr="S\\1", baseFolder = "Finder", test = TRUE)
}
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other File Functions: \code{\link{dl_from_dropbox}},
  \code{\link{umx_SQL_from_Excel}},
  \code{\link{umx_move_file}}, \code{\link{umx_open}},
  \code{\link{umx}}
}

