% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umxDescribeDataWLS}
\alias{umxDescribeDataWLS}
\title{Determine whether a dataset will have weights and summary statistics for the means if used with mxFitFunctionWLS}
\usage{
umxDescribeDataWLS(data, allContinuousMethod = c("cumulants",
  "marginals"), verbose = FALSE)
}
\arguments{
\item{data}{the (currently raw) data being used in a \code{\link{mxFitFunctionWLS}} model.}

\item{allContinuousMethod}{the method used to process data when all columns are continuous.}

\item{verbose}{logical. Whether to report diagnostics.}
}
\value{
- list describing the data.
}
\description{
Given either a data.frame or an mxData of type raw, this function determines whether \code{mxFitFunctionWLS}
will generate expectations for means.
}
\details{
All-continuous data processed using the "cumulants" method lack means, while
all continuous data processed with allContinuousMethod = "marginals" will have means.

When data are not all continuous, allContinuousMethod is ignored, and means are modeled.
}
\examples{

# ====================================
# = All continuous, data.frame input =
# ====================================

tmp = umxDescribeDataWLS(mtcars, allContinuousMethod= "cumulants", verbose = TRUE)
tmp$hasMeans # FALSE - no means with cumulants
tmp = umxDescribeDataWLS(mtcars, allContinuousMethod= "marginals") 
tmp$hasMeans # TRUE we get means with marginals

# ==========================
# = mxData object as input =
# ==========================
tmp = mxData(mtcars, type="raw")
umxDescribeDataWLS(tmp, allContinuousMethod= "cumulants", verbose = TRUE)$hasMeans # FALSE
umxDescribeDataWLS(tmp, allContinuousMethod= "marginals")$hasMeans  # TRUE

# =======================================
# = One var is a factor: Means modeled =
# =======================================
tmp = mtcars
tmp$cyl = factor(tmp$cyl)
umxDescribeDataWLS(tmp, allContinuousMethod= "cumulants")$hasMeans # TRUE - always has means
umxDescribeDataWLS(tmp, allContinuousMethod= "marginals")$hasMeans # TRUE

}
\seealso{
- \code{\link{mxFitFunctionWLS}}, \code{\link{omxAugmentDataWithWLSSummary}}

Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}}, \code{\link{umx_cov2raw}},
  \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_TwinData}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_polychoric}},
  \code{\link{umx_polypairwise}},
  \code{\link{umx_polytriowise}},
  \code{\link{umx_read_lower}}, \code{\link{umx_rename}},
  \code{\link{umx_reorder}}, \code{\link{umx_stack}},
  \code{\link{umx_swap_a_block}}, \code{\link{umx}}
}
\concept{Data Functions}
