% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_dot_rank}
\alias{umx_dot_rank}
\title{Helper to make a graphviz rank string}
\usage{
umx_dot_rank(vars, pattern, rank)
}
\arguments{
\item{vars}{a list of strings}

\item{pattern}{regular expression to filter vars}

\item{rank}{"same", "max", "min"}
}
\value{
string
}
\description{
Given a list of names, this filters the list, and returns a graphviz string to force them into the given rank.
e.g. "{rank=same; as1};"
}
\examples{
umx_dot_rank(c("as1"), "^[ace]s[0-9]+$", "same")
}
\seealso{
- \code{\link{umx_dot_define_shapes}}

Other Graphviz: \code{\link{umx_dot_define_shapes}},
  \code{\link{umx_dot_mat2dot}},
  \code{\link{xmu_dot_make_paths}},
  \code{\link{xmu_dot_make_residuals}},
  \code{\link{xmu_dot_maker}}
}
\concept{Graphviz}
