% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxRotate.MxModelCP}
\alias{umxRotate.MxModelCP}
\title{Rotate a CP solution}
\usage{
\method{umxRotate}{MxModelCP}(model, rotation = c("varimax", "promax"),
  tryHard = "yes", freeLoadingsAfter = TRUE, verbose = TRUE)
}
\arguments{
\item{model}{a \code{\link[=umxCP]{umxCP()}} model to rotate.}

\item{rotation}{name of the rotation.}

\item{tryHard}{Default ("yes") is to tryHard.}

\item{freeLoadingsAfter}{return the model with factor loadings free (default) or fixed in the new locations.}

\item{verbose}{print detail about the rotation}
}
\value{
\itemize{
\item Rotated solution.
}
}
\description{
Rotate a CP solution.
Should work with rotations provided in \code{library("GPArotation")} and \code{library("psych")}, e.g

\strong{Orthogonal}: "varimax", "quartimax", "bentlerT", "equamax", "varimin", "geominT" and "bifactor"

\strong{Oblique}: "Promax", "promax", "oblimin", "simplimax", "bentlerQ", "geominQ", "biquartimin" and "cluster"
}
\details{
This works by taking the common-pathways loadings matrix from a solved \code{\link[=umxCP]{umxCP()}} model, rotating these, placing
them back into the loadings matrix, re-estimating the model with the parameters fixed at this rotation, then return the new model.
}
\examples{
# Rotate a CP solution(param)
# Common pathway model rotation
\dontrun{
library(umx)
# Fit 3 factor CPM
data(GFF)
selDVs = c("gff", "fc", "qol", "hap", "sat", "AD") 
m1 = umxCP(selDVs = selDVs, nFac = 2, data = data, tryHard = "yes")
m2 = umxRotate(m1, rotation = "varimax",  tryHard = "yes")

}
}
\seealso{
\itemize{
\item \code{\link[=umxCP]{umxCP()}}
}

Other Twin Modeling Functions: \code{\link{power.ACE.test}()},
  \code{\link{umxACE_cov_fixed}()},
  \code{\link{umxACEcov}()}, \code{\link{umxACEv}()},
  \code{\link{umxACE}()}, \code{\link{umxCP}()},
  \code{\link{umxGxE_window}()}, \code{\link{umxGxEbiv}()},
  \code{\link{umxGxE}()}, \code{\link{umxIP}()},
  \code{\link{umxSexLim}()}, \code{\link{umxSimplex}()},
  \code{\link{umx}}
}
\concept{Twin Modeling Functions}
