% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_is_RAM}
\alias{umx_is_RAM}
\title{umx_is_RAM}
\usage{
umx_is_RAM(obj)
}
\arguments{
\item{obj}{an object to be tested to see if it is an OpenMx RAM \code{\link[=mxModel]{mxModel()}}}
}
\value{
\itemize{
\item Boolean
}
}
\description{
Utility function returning a binary answer to the question "Is this a RAM model?"
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("is_RAM_ex", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)

if(umx_is_RAM(m1)){
	message("nice RAM model!")
}
if(!umx_is_RAM(m1)){
	message("model needs to be a RAM model")
}
}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
Other Test: 
\code{\link{umx_check_OS}()},
\code{\link{umx_check_model}()},
\code{\link{umx_check_names}()},
\code{\link{umx_check_parallel}()},
\code{\link{umx_check}()},
\code{\link{umx_has_CIs}()},
\code{\link{umx_has_been_run}()},
\code{\link{umx_has_means}()},
\code{\link{umx_has_square_brackets}()},
\code{\link{umx_is_MxData}()},
\code{\link{umx_is_MxMatrix}()},
\code{\link{umx_is_MxModel}()},
\code{\link{umx_is_cov}()}
}
\concept{Test}
