% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxExpMeans}
\alias{umxExpMeans}
\title{Extract the expected means matrix from an \code{\link[=mxModel]{mxModel()}}}
\usage{
umxExpMeans(model, manifests = TRUE, latents = NULL, digits = NULL)
}
\arguments{
\item{model}{an \code{\link[=mxModel]{mxModel()}} to get the means from}

\item{manifests}{Whether to select the manifest variables (defaults to TRUE)}

\item{latents}{Whether to select the latent variables (defaults to TRUE)}

\item{digits}{precision of reporting. Default (NULL) will not round at all.}
}
\value{
\itemize{
\item expected means
}
}
\description{
Extract the expected means matrix from an \code{\link[=mxModel]{mxModel()}}
}
\examples{
\dontrun{

require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor,
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)

umxExpMeans(m1)
umxExpMeans(m1, digits = 3)
}
}
\references{
\itemize{
\item \url{https://openmx.ssri.psu.edu/thread/2598}
}
}
\seealso{
Other Reporting functions: 
\code{\link{RMSEA.MxModel}()},
\code{\link{RMSEA.summary.mxmodel}()},
\code{\link{RMSEA}()},
\code{\link{extractAIC.MxModel}()},
\code{\link{loadings}()},
\code{\link{residuals.MxModel}()},
\code{\link{tmx_show.MxMatrix}()},
\code{\link{tmx_show}()},
\code{\link{umxCI_boot}()},
\code{\link{umxCI}()},
\code{\link{umxConfint}()},
\code{\link{umxExpCov}()},
\code{\link{umxFitIndices}()},
\code{\link{umxRotate}()}
}
\concept{Reporting functions}
