% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_check_names}
\alias{umx_check_names}
\title{Check if a request name exists in a dataframe or related object}
\usage{
umx_check_names(
  namesNeeded,
  data = NA,
  die = TRUE,
  no_others = FALSE,
  intersection = FALSE,
  message = ""
)
}
\arguments{
\item{namesNeeded}{list of variable names to find (a dataframe is also allowed)}

\item{data}{data.frame, matrix, or mxData to search in for names (default NA)}

\item{die}{whether to die if the check fails (default TRUE)}

\item{no_others}{Whether to test that the data contain no columns in addition to those in namesNeeded (default FALSE)}

\item{intersection}{Show the intersection of names}

\item{message}{Some helpful text to append when dieing.}
}
\description{
Check if a list of names are in the [namez()] of a dataframe (or the [dimnames()] of a matrix), or the names of 
the observed data of an [mzData()]
}
\examples{
require(umx)
data(demoOneFactor) # "x1" "x2" "x3" "x4" "x5"
umx_check_names(c("x1", "x2"), demoOneFactor)
umx_check_names(c("x1", "x2"), as.matrix(demoOneFactor))
umx_check_names(c("x1", "x2"), cov(demoOneFactor[, c("x1","x2")]))
umx_check_names(c("x1", "x2"), mxData(demoOneFactor, type="raw"))
umx_check_names(c("z1", "x2"), data = demoOneFactor, die = FALSE)
umx_check_names(c("x1", "x2"), data = demoOneFactor, die = FALSE, no_others = TRUE)
umx_check_names(c("x1","x2","x3","x4","x5"), data = demoOneFactor, die = FALSE, no_others = TRUE)
# no request
umx_check_names(c(), data = demoOneFactor, die = FALSE, no_others = TRUE)

\dontrun{
# An example error from vars that don't exist in the data
umx_check_names(c("bad_var_name", "x2"), data = demoOneFactor, die = TRUE)
}
}
\references{
- <https://github.com/tbates/umx>
}
\seealso{
Other Test: 
\code{\link{umx_check_OS}()},
\code{\link{umx_check_model}()},
\code{\link{umx_check_parallel}()},
\code{\link{umx_check}()},
\code{\link{umx_has_CIs}()},
\code{\link{umx_has_been_run}()},
\code{\link{umx_has_means}()},
\code{\link{umx_has_square_brackets}()},
\code{\link{umx_is_MxData}()},
\code{\link{umx_is_MxMatrix}()},
\code{\link{umx_is_MxModel}()},
\code{\link{umx_is_RAM}()},
\code{\link{umx_is_cov}()}

Other Check or test: 
\code{\link{umx_is_class}()},
\code{\link{umx_is_endogenous}()},
\code{\link{umx_is_exogenous}()},
\code{\link{umx_is_numeric}()},
\code{\link{umx_is_ordered}()},
\code{\link{umx}}
}
\concept{Check or test}
\concept{Test}
