% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_read_prolific_demog}
\alias{umx_read_prolific_demog}
\title{Read and optionally merge demographics file from prolific academic}
\usage{
umx_read_prolific_demog(
  file,
  base = "",
  df = NULL,
  verbose = FALSE,
  by.df = "PID",
  by.demog = "participant_id",
  vars = c("age", "Sex"),
  all.df = TRUE,
  all.demog = FALSE
)
}
\arguments{
\item{file}{Path to a file to read.}

\item{base}{Optional path to folder}

\item{df}{Optional existing datafile}

\item{verbose}{Whether to print names in the file.}

\item{by.df}{The ID name in your datafile (default = "PID")}

\item{by.demog}{The ID name in the prolific demographics file (default = "participant_id")}

\item{vars}{Vars to keep from demographics file (default =  age & Sex)}

\item{all.df}{Whether to keep all lines of df (default = TRUE)}

\item{all.demog}{Whether to keep all lines (people) in the demographics file (default = FALSE)}
}
\value{
\itemize{
\item [\link{data.frame}]
}
}
\description{
prolific academic provides a demographics file. This reads it and merges with your data
using PID and participant_id
}
\examples{
\dontrun{
fp = "~/Desktop/prolific_export_5f20c3e662e3b6407dcd37a5.csv"
df = umx_read_prolific_demog(fp, df = df)
tmp = umx_read_prolific_demog(demog= fp, base = "", df = NULL, verbose = FALSE)
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
Other Data Functions: 
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_as_numeric}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_fake_data}()},
\code{\link{umx_make_raw_from_cov}()},
\code{\link{umx_polychoric}()},
\code{\link{umx_polypairwise}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_rename}()},
\code{\link{umx_reorder}()},
\code{\link{umx_select_valid}()},
\code{\link{umx_stack}()},
\code{\link{umx}}
}
\concept{Data Functions}
