% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/X.pathway_discrete.balanced.R
\name{X.pathway_discrete.balanced}
\alias{X.pathway_discrete.balanced}
\title{Generate a matrix of gene expressions (discrete version of X.pathway() against to Emura (2012)) in the presence of gene pathways}
\usage{
X.pathway_discrete.balanced(n, p, q1, q2, rho1 = 0.5, rho2 = 0.5)
}
\arguments{
\item{n}{:the number of individuals (sample size)}

\item{p}{:the number of genes}

\item{q1}{:the number of genes in the first pathway}

\item{q2}{:the number of genes in the second pathway}

\item{rho1}{:the correlation coefficient for the first pathway}

\item{rho2}{:the correlation coefficient for the second pathway}
}
\value{
X	n by p matrix of gene expressions
}
\description{
Generate a matrix of gene expressions in the presence of gene pathways, we first produce the matrix by X.pathway(Emura et al. 2012), then we change each value to 1 ~ 4 depend on the quantile.
}
\examples{
## generate 6 gene expressions from 10 individuals
X.pathway_discrete.balanced(n=10,p=6,q1=2,q2=2,rho1=0.5,rho2=0.5)
}
\references{
Emura T, Chen YH, Chen HY (2012). Survival Prediction Based on Compound Covariate under Cox Proportional Hazard Models. PLoS ONE 7(10): e47627. doi:10.1371/journal.pone.0047627
}
