% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Florida.R
\docType{data}
\name{uflorida_1}
\alias{uflorida_1}
\title{Primary colors of the University of Florida, USA}
\format{
An object of class \code{character} of length 2.
}
\source{
Color definitions are based on the 
\href{https://brandcenter.ufl.edu/colors/}{UFL brand center}.
}
\usage{
uflorida_1
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uflorida_1} provides the two primary colors
of the \href{https://www.ufl.edu/}{University of Florida}, USA.
}
\details{
The 2 primary colors are
\code{"ufl_core orange"} (defined as HEX #FA416) and
\code{"ufl_core_blue"} (defined as HEX #0021A5).

\code{uflorida_1} uses the HEX color definitions.
}
\examples{
uflorida_1
unikn::seecol(uflorida_1, main = "University of Florida 1") # view color palette.

}
\seealso{
\code{\link{uflorida_2}} for secondary colors of the University of Florida; 
\code{\link{uflorida_3}} for neutral colors of the University of Florida; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_2}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-07-21.
}
\concept{U.S. university color palettes}
\keyword{datasets}
