% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Hamburg.R
\docType{data}
\name{uni_hamburg_2}
\alias{uni_hamburg_2}
\title{Secondary colors of the University of Hamburg, Germany}
\format{
An object of class \code{character} of length 6.
}
\source{
Color definitions are based on the 
\href{https://www.fiona.uni-hamburg.de/beantragung/regelungen.html}{CD manual}.
}
\usage{
uni_hamburg_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_hamburg_2} provides three primary colors 
of the \href{https://www.uni-hamburg.de}{University of Hamburg}, Germany, 
in combination with two pair-wise variants of them.
}
\details{
\code{uni_hamburg_2} is to be used in visualizations.
}
\examples{
uni_hamburg_2
unikn::seecol(uni_hamburg_2, main = "Visualization colors of the University of Hamburg")
unikn::demopal(uni_hamburg_2, type = 1, main = "Secondary colors of the Uni Hamburg")

}
\seealso{
\code{\link{uni_hamburg_1}} for primary colors of the University of Hamburg;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_1}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2022-12-06.
}
\concept{German university color palettes}
\keyword{datasets}
