% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_texture.R
\name{add_texture}
\alias{add_texture}
\title{Add a Texture2D layer to a terrain tile object}
\usage{
add_texture(script, method_name = NULL, exec = FALSE)
}
\arguments{
\item{script}{A \code{unifir_script} object, created by \link{make_script} or returned
by an \verb{add_prop_*} function.}

\item{method_name}{The internal name to use for the C# method created. Will
be randomly generated if not set.}

\item{exec}{Logical: Should the C# method be included in the set executed by
MainFunc?}
}
\value{
The \code{unifir_script} object passed to \code{script}, with an \code{AddTexture}
method appended.
}
\description{
This function adds a helper method, \code{AddTexture}, to the
C# script. This function is typically used to add textures to
heightmaps in a Unity scene, for instance by functions
like \link{create_terrain}. It requires some arguments be provided
at the C# level, and so is almost always called with \code{exec = FALSE}.
}
\examples{
# First, create a script object.
# CRAN doesn't have Unity installed, so pass
# a waiver object to skip the Unity-lookup stage:
script <- make_script("example_script",
  unity = waiver()
)

# Now add props:
script <- add_texture(script)

# Lastly, execute the script via the `action` function

}
\seealso{
Other props: 
\code{\link{add_default_player}()},
\code{\link{add_light}()},
\code{\link{add_prop}()},
\code{\link{create_terrain}()},
\code{\link{import_asset}()},
\code{\link{instantiate_prefab}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()}
}
\concept{props}
