% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unigd.R
\name{ugd_render_inline}
\alias{ugd_render_inline}
\title{Inline plot rendering.}
\usage{
ugd_render_inline(
  code,
  page = 0,
  width = getOption("unigd.width", 720),
  height = getOption("unigd.height", 576),
  zoom = 1,
  as = "svg",
  ...
)
}
\arguments{
\item{code}{Plotting code. See examples for more information.}

\item{page}{Plot page to render. If this is set to \code{0}, the last page will
be selected. Can be set to a numeric plot index or plot ID
(see \code{\link[=ugd_id]{ugd_id()}}).}

\item{width}{Width of the plot.}

\item{height}{Height of the plot.}

\item{zoom}{Zoom level. (For example: \code{2} corresponds to 200\%, \code{0.5} would
be 50\%.)}

\item{as}{Renderer.}

\item{...}{Additional parameters passed to \code{ugd(...)}}
}
\value{
Rendered plot. Text renderers return strings, binary renderers
return byte arrays.
}
\description{
Convenience function for quick inline plot rendering.
This is similar to \code{\link[=ugd_render]{ugd_render()}} but the plotting code
is specified inline and an unigd graphics device is managed
(created and closed) automatically. Starting a device with \code{\link[=ugd]{ugd()}} is
therefore not necessary.
}
\examples{
ugd_render_inline({
  hist(rnorm(100))
}, as = "svgz")

s <- ugd_render_inline({
  plot.new()
  lines(c(0.5, 1, 0.5), c(0.5, 1, 1))
})
cat(s)
}
