% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_fun.R
\name{seecol}
\alias{seecol}
\alias{seepal}
\title{Plot color palettes (to see their colors).}
\usage{
seecol(pal = "unikn_all", n = "all", alpha = NA, hex = NULL,
  rgb = NULL, col_bg = NULL, col_brd = NULL, lwd_brd = NULL,
  grid = TRUE, title = NA, ...)
}
\arguments{
\item{pal}{A color palette (as a vector of colors), 
a character string recognized as keyword by seecol or
multiple palettes specified as list. 
Default: \code{pal = "unikn_all"}. 

Recognized keywords are: 

\enumerate{

  \item \code{"unikn_all"}: All color palettes defined in \code{unikn}

  \item \code{"unikn_basic"}: All basic palettes. 
  
  \item \code{"pair_all"}: All palettes with pairwise colors. 
  
  \item \code{"pref_all"}: All preferred colors and their gradients. 
  
  \item \code{"grad_all"}: 

}

\code{seecol} does also recognize reverse keywords (e.g., \code{"all_unikn"}) or 
keywords without \code{"unikn"} (e.g., \code{"basic"}).}

\item{n}{Number of colors to show or use. 
If \code{n} is lower or higher than the length of the current 
color palette \code{pal}, the color palette is reduced or extrapolated 
(using \code{grDevices::colorRampPalette}). 
Default: \code{n = "all"} (i.e., show all colors in palette).}

\item{alpha}{A factor modifying the opacity alpha (as in \code{\link{adjustcolor}}); 
typically in [0,1]. If used, the value is shown in the plot title.
Default: \code{alpha = NA} (i.e., no modification of opacity).}

\item{hex}{Should HEX color values be shown? 
Default: \code{hex = NULL} (i.e., show HEX color values 
when there is sufficient space to print them).}

\item{rgb}{Should RGB color values be shown?
Default: \code{rgb = NULL} (i.e., show RGB color values 
when there is sufficient space to print them).}

\item{col_bg}{Color of plot background. 
Default: \code{col_bg = NULL}.}

\item{col_brd}{Color of shape borders (if shown). 
Default: \code{col_brd = NULL}.}

\item{lwd_brd}{Line width of shape borders (if shown). 
Default: \code{lwd_brd = NULL}.}

\item{grid}{Show grid in the color plot?
Default: \code{grid = TRUE}.}

\item{title}{Plot title? 
Default: \code{title = NA} creates a default title.}

\item{...}{Other graphical parameters 
(passed to \code{plot}).}
}
\description{
\code{seecol} provides an interface to plotting (or "seeing") 
the colors of a palette or comparing multiple color palettes.
}
\details{
\code{seecol} has 2 main modes, based on the contents of its \code{pal} argument:

\enumerate{

\item if \code{pal = "unikn_all"} (or a list of multiple color palettes):

Plot visual vectors of all current color palettes for comparing them.

\item if \code{pal} is set to a specific color palette (or a vector of multiple colors or color palettes):

Plot the current color palette and optional details on its colors.

}
}
\examples{
# See all color palettes: 
seecol()  # same as seecol(pal = "all") 

# See details of a color palette: 
seecol(pal_unikn)  # see a specific color palette

# Combining colors or color palettes: 
seecol(c(rev(pal_seeblau), pal_seegruen))        # combine color palettes
seecol(c(rev(pal_seeblau), "white", pal_pinky))  # combine color palettes and color names
seecol(c("black", "firebrick", "gold"))          # combine color names

# Using n to reduce or extend color palettes:
seecol(n =  3)  # viewing reduced ranges of all palettes
seecol(n = 12)  # viewing extended ranges of all palettes

seecol(pal_unikn, n = 5, 
       title = "Reduced version of pal_unikn (n = 5)")  # reducing pal_unikn
seecol(pal_seeblau, n = 8, 
       title = "Extended version of pal_seeblau (n = 8)")  # extending pal_seeblau

# Combining and extending color palettes: 
seecol(c(rev(pal_seeblau), "white", pal_bordeaux), n = 17, 
       title = "Diverging custom color palette with 17 colors")

# Defining custom color palettes:
pal_mpg <- c("#007367", "white", "#D0D3D4")
names(pal_mpg) <- c("mpg green", "mpg white", "mpg grey")

# Viewing extended color palette: 
seecol(pal_mpg, n = 9, title = "Custom color palette for Max Planck Society")

# Comparing color palettes: 
seecol(list(pal_mpg, pal_bordeaux, pal_unikn), n = 5)

## Viewing color palettes from other packages: 
# library(RColorBrewer)
# seecol(brewer.pal(name = "RdBu", n = 11))  # viewing "RdBu" palette from RColorBrewer

## Extending color palettes:
# seecol(brewer.pal(name = "RdBu", n = 11), n = 15)  # extending palette to 15 colors

}
\seealso{
\code{\link{usecol}} to use a color palette; 
\code{\link{pal_unikn}} for the default uni.kn color palette.

Other color functions: \code{\link{newpal}},
  \code{\link{usecol}}
}
\concept{color functions}
