% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rflexdog.R
\name{rflexdog}
\alias{rflexdog}
\title{Simulate GBS data from the \code{\link{flexdog}} likelihood.}
\usage{
rflexdog(sizevec, geno, ploidy, seq = 0.005, bias = 1, od = 0.001)
}
\arguments{
\item{sizevec}{A vector of total read-counts for the individuals.}

\item{geno}{A vector of genotypes for the individuals. I.e. the number of reference alleles
each individual has.}

\item{ploidy}{The ploidy of the species.}

\item{seq}{The sequencing error rate.}

\item{bias}{The bias parameter. Pr(a read after selected) / Pr(A read after selected).}

\item{od}{The overdispersion parameter. See the
Details of the \code{rho} variable in \code{\link{betabinom}}.}
}
\value{
A vector the same length as \code{sizevec}. The ith element
    is the number of reference counts for individual i.
}
\description{
This will take a vector of genotypes and a vector of total read-counts, then generate a vector of reference
counts. To get the genotypes, you could use \code{\link{rgeno}}.
}
\examples{
set.seed(1)
n       <- 100
ploidy  <- 6

## Generate the genotypes of individuals from an F1 population,
## where the first parent has 1 copy of the reference allele
## and the second parent has two copies of the reference
## allele.
genovec <- rgeno(n = n, ploidy = ploidy, model = "f1",
                 p1geno = 1, p2geno = 2)

## Get the total number of read-counts for each individual.
## Ideally, you would take this from real data as the total
## read-counts are definitely not Poisson.
sizevec <- stats::rpois(n = n, lambda = 200)

## Generate the counts of reads with the reference allele
## when there is a strong bias for the reference allele
## and there is no overdispersion.
refvec  <- rflexdog(sizevec = sizevec, geno = genovec,
                    ploidy = ploidy, seq = 0.001,
                    bias = 0.5, od = 0)

## Plot the simulated data using plot_geno.
plot_geno(refvec = refvec, sizevec = sizevec,
          ploidy = ploidy, seq = 0.001, bias = 0.5)

}
\references{
Gerard, David, Luis Felipe Ventorim Ferrao,
Antonio Augusto Franco Garcia, and Matthew Stephens. 2018.
"Harnessing Empirical Bayes and Mendelian Segregation
for Genotyping Autopolyploids from Messy Sequencing Data."
\emph{bioRxiv}. Cold Spring Harbor Laboratory. doi:10.1101/281550.
}
\seealso{
\code{\link{rgeno}} for a way to generate genotypes of individuals. \code{\link{rbetabinom}}
    for how we generate the read-counts.
}
\author{
David Gerard
}
