% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_bivalent_probs}
\alias{get_bivalent_probs}
\title{Returns segregation probabilities, pairing representation
and number of ref alleles given the ploidy.}
\usage{
get_bivalent_probs(ploidy)
}
\arguments{
\item{ploidy}{The ploidy of the individual. Should be even
and greater than 0.}
}
\value{
A list of three elements
\describe{
\item{\code{probmat}}{The rows index the pairing configuration
    and the columns index the number of reference alleles
    segregating. The elements are the probability of
    segregating the given number of reference alleles
    in a given category.}
\item{\code{pmat}}{The pairing representation of the
    configuration.}
\item{\code{lvec}}{The number of reference alleles an individual
    has given their pairing configuration in \code{pmat}.}
}
}
\description{
Returns segregation probabilities, pairing representation
and number of ref alleles given the ploidy.
}
\examples{
get_bivalent_probs(4)

}
\author{
David Gerard
}
